<?php

use app\models\Application;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\ApplicationSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Управление заказами';

?>
<div class="admin-applications">

    <!-- Header -->
    <div class="admin-header">
        <div class="header-content">
            <h1 class="page-title">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="currentColor" class="page-icon">
                    <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m2-8h1m-1 4h1m-1 4h1m-7 4v-1m0-4v-1m0-4V8"/>
                </svg>
                Управление заказами
            </h1>
            <p class="page-subtitle">Просмотр и управление всеми заказами системы</p>
        </div>
        <div class="header-stats">
            <div class="stat-card">
                <div class="stat-icon primary">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                    </svg>
                </div>
                <div class="stat-info">
                    <span class="stat-value"><?= $dataProvider->getTotalCount() ?></span>
                    <span class="stat-label">Всего заказов</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters and Actions -->
    <div class="admin-toolbar">
        <div class="toolbar-actions">
            <button class="btn btn-primary">
                <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                </svg>
                Экспорт данных
            </button>
            <button class="btn btn-secondary">
                <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"/>
                </svg>
                Фильтры
            </button>
        </div>
        <div class="toolbar-search">
            <div class="search-wrapper">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="search-icon">
                    <path d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <input type="text" class="search-input" placeholder="Поиск заказов...">
            </div>
        </div>
    </div>

    <!-- Applications Table -->
    <div class="applications-table-container">
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'filterModel' => $searchModel,
            'tableOptions' => ['class' => 'modern-table'],
            'options' => ['class' => 'grid-view-modern'],
            'layout' => "{items}\n{pager}",
            'columns' => [
                [
                    'class' => 'yii\grid\SerialColumn',
                    'header' => '#',
                    'headerOptions' => ['class' => 'table-header'],
                    'contentOptions' => ['class' => 'table-cell serial'],
                ],
                [
                    'attribute' => 'id',
                    'header' => 'ID заказа',
                    'headerOptions' => ['class' => 'table-header'],
                    'contentOptions' => ['class' => 'table-cell id-cell'],
                    'filterOptions' => ['class' => 'filter-cell'],
                ],
                [
                    'attribute' => 'user_id',
                    'header' => 'Пользователь',
                    'headerOptions' => ['class' => 'table-header'],
                    'contentOptions' => ['class' => 'table-cell user-cell'],
                    'filterOptions' => ['class' => 'filter-cell'],
                ],
                [
                    'attribute' => 'category_id',
                    'header' => 'Категория',
                    'headerOptions' => ['class' => 'table-header'],
                    'contentOptions' => ['class' => 'table-cell category-cell'],
                    'filterOptions' => ['class' => 'filter-cell'],
                ],
                [
                    'attribute' => 'product_id',
                    'header' => 'Товар',
                    'headerOptions' => ['class' => 'table-header'],
                    'contentOptions' => ['class' => 'table-cell product-cell'],
                    'filterOptions' => ['class' => 'filter-cell'],
                ],
                [
                    'attribute' => 'count_product',
                    'header' => 'Количество',
                    'headerOptions' => ['class' => 'table-header'],
                    'contentOptions' => ['class' => 'table-cell count-cell'],
                    'filterOptions' => ['class' => 'filter-cell'],
                ],
                [
                    'attribute' => 'date',
                    'header' => 'Дата',
                    'headerOptions' => ['class' => 'table-header'],
                    'contentOptions' => ['class' => 'table-cell date-cell'],
                    'filterOptions' => ['class' => 'filter-cell'],
                    'format' => 'datetime',
                ],
                [
                    'class' => ActionColumn::className(),
                    'header' => 'Действия',
                    'headerOptions' => ['class' => 'table-header actions-header'],
                    'contentOptions' => ['class' => 'table-cell actions-cell'],
                    'template' => '{view} {update} {delete}',
                    'buttons' => [
                        'view' => function ($url, $model, $key) {
                            return Html::a(
                                '<svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                                    <circle cx="12" cy="12" r="3"/>
                                </svg>',
                                $url,
                                [
                                    'class' => 'action-btn view-btn',
                                    'title' => 'Просмотр',
                                    'data-toggle' => 'tooltip'
                                ]
                            );
                        },
                        'update' => function ($url, $model, $key) {
                            return Html::a(
                                '<svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                </svg>',
                                $url,
                                [
                                    'class' => 'action-btn edit-btn',
                                    'title' => 'Редактировать',
                                    'data-toggle' => 'tooltip'
                                ]
                            );
                        },
                        'delete' => function ($url, $model, $key) {
                            return Html::a(
                                '<svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                </svg>',
                                $url,
                                [
                                    'class' => 'action-btn delete-btn',
                                    'title' => 'Удалить',
                                    'data-toggle' => 'tooltip',
                                    'data-confirm' => 'Вы уверены, что хотите удалить этот заказ?',
                                    'data-method' => 'post'
                                ]
                            );
                        },
                    ],
                    'urlCreator' => function ($action, Application $model, $key, $index, $column) {
                        return Url::toRoute([$action, 'id' => $model->id]);
                    }
                ],
            ],
            'pager' => [
                'options' => ['class' => 'modern-pager'],
                'linkOptions' => ['class' => 'pager-link'],
                'activePageCssClass' => 'pager-active',
                'prevPageCssClass' => 'pager-prev',
                'nextPageCssClass' => 'pager-next',
            ],
        ]); ?>
    </div>

</div>

<style>
    .admin-applications {
        max-width: 1400px;
        margin: 0 auto;
        padding: 2rem;
    }

    /* Header */
    .admin-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 2rem;
        gap: 2rem;
    }

    .header-content {
        flex: 1;
    }

    .page-title {
        display: flex;
        align-items: center;
        gap: 1rem;
        font-size: 2rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }

    .page-icon {
        color: #667eea;
    }

    .page-subtitle {
        font-size: 1.125rem;
        color: #6b7280;
        margin: 0;
    }

    .header-stats {
        display: flex;
        gap: 1.5rem;
    }

    .stat-card {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1.5rem;
        background: white;
        border-radius: 1rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid #e5e7eb;
        min-width: 180px;
    }

    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 0.75rem;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .stat-icon.primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .stat-info {
        display: flex;
        flex-direction: column;
    }

    .stat-value {
        font-size: 1.875rem;
        font-weight: 700;
        color: #1f2937;
        line-height: 1;
    }

    .stat-label {
        font-size: 0.875rem;
        color: #6b7280;
        margin-top: 0.25rem;
    }

    /* Toolbar */
    .admin-toolbar {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        padding: 1.5rem;
        background: white;
        border-radius: 1rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid #e5e7eb;
    }

    .toolbar-actions {
        display: flex;
        gap: 1rem;
    }

    .btn {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.75rem 1.5rem;
        border: none;
        border-radius: 0.75rem;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        font-size: 0.875rem;
    }

    .btn-primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
    }

    .btn-secondary {
        background: #f8fafc;
        color: #374151;
        border: 1px solid #e5e7eb;
    }

    .btn-secondary:hover {
        background: #f3f4f6;
        border-color: #d1d5db;
    }

    .toolbar-search {
        flex: 0 0 300px;
    }

    .search-wrapper {
        position: relative;
    }

    .search-icon {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
    }

    .search-input {
        width: 100%;
        padding: 0.75rem 1rem 0.75rem 2.5rem;
        border: 1px solid #e5e7eb;
        border-radius: 0.75rem;
        font-size: 0.875rem;
        transition: all 0.3s ease;
        background: #f8fafc;
    }

    .search-input:focus {
        outline: none;
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    /* Table */
    .applications-table-container {
        background: white;
        border-radius: 1rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid #e5e7eb;
        overflow: hidden;
    }

    .grid-view-modern {
        background: white;
    }

    .modern-table {
        width: 100%;
        border-collapse: collapse;
        margin: 0;
    }

    .table-header {
        background: #f8fafc;
        padding: 1rem 1.5rem;
        font-weight: 600;
        color: #374151;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }

    .table-cell {
        padding: 1rem 1.5rem;
        border-bottom: 1px solid #f3f4f6;
        color: #374151;
        font-size: 0.875rem;
    }

    .table-cell.serial {
        color: #6b7280;
        font-weight: 500;
    }

    .table-cell.id-cell {
        font-weight: 600;
        color: #667eea;
    }

    .table-cell.user-cell,
    .table-cell.category-cell,
    .table-cell.product-cell {
        font-weight: 500;
    }

    .table-cell.count-cell {
        text-align: center;
        font-weight: 600;
        color: #059669;
    }

    .table-cell.date-cell {
        color: #6b7280;
    }

    .actions-cell {
        text-align: center;
        white-space: nowrap;
    }

    .action-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 36px;
        height: 36px;
        border: none;
        border-radius: 0.5rem;
        margin: 0 0.125rem;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
    }

    .view-btn {
        background: #dbeafe;
        color: #1d4ed8;
    }

    .view-btn:hover {
        background: #1d4ed8;
        color: white;
    }

    .edit-btn {
        background: #fef3c7;
        color: #d97706;
    }

    .edit-btn:hover {
        background: #d97706;
        color: white;
    }

    .delete-btn {
        background: #fee2e2;
        color: #dc2626;
    }

    .delete-btn:hover {
        background: #dc2626;
        color: white;
    }

    /* Pager */
    .modern-pager {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 0.5rem;
        padding: 1.5rem;
        background: #f8fafc;
        border-top: 1px solid #e5e7eb;
    }

    .pager-link {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        min-width: 40px;
        height: 40px;
        padding: 0 0.75rem;
        border: 1px solid #e5e7eb;
        border-radius: 0.5rem;
        color: #374151;
        text-decoration: none;
        font-weight: 500;
        transition: all 0.3s ease;
        background: white;
    }

    .pager-link:hover {
        border-color: #667eea;
        color: #667eea;
    }

    .pager-active {
        background: #667eea;
        border-color: #667eea;
        color: white;
    }

    .pager-prev,
    .pager-next {
        font-weight: 600;
    }

    /* Responsive */
    @media (max-width: 1024px) {
        .admin-header {
            flex-direction: column;
        }

        .header-stats {
            width: 100%;
            justify-content: flex-start;
        }
    }

    @media (max-width: 768px) {
        .admin-applications {
            padding: 1rem;
        }

        .admin-toolbar {
            flex-direction: column;
            gap: 1rem;
            align-items: stretch;
        }

        .toolbar-actions {
            justify-content: center;
        }

        .toolbar-search {
            flex: none;
            width: 100%;
        }

        .page-title {
            font-size: 1.75rem;
        }

        .table-header,
        .table-cell {
            padding: 0.75rem 1rem;
        }
    }

    @media (max-width: 640px) {
        .stat-card {
            min-width: auto;
            flex: 1;
        }

        .modern-table {
            display: block;
            overflow-x: auto;
        }
    }
</style>