<?php

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\widgets\MaskedInput; ?>

<div class="order-container">
    <div class="order-wrapper">
        <!-- Левая часть с информацией -->
        <div class="order-hero">
            <div class="hero-content">
                <h1>Оформление заказа</h1>
                <p>Заполните форму для доставки натуральных продуктов</p>
                <div class="order-features">
                    <div class="feature-item">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                        </svg>
                        <span>Быстрая доставка</span>
                    </div>
                    <div class="feature-item">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span>Гарантия качества</span>
                    </div>
                    <div class="feature-item">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                        </svg>
                        <span>Безопасная оплата</span>
                    </div>
                </div>
            </div>
            <div class="floating-elements">
                <div class="floating-element el-1"></div>
                <div class="floating-element el-2"></div>
                <div class="floating-element el-3"></div>
            </div>
        </div>

        <!-- Правая часть с формой -->
        <div class="order-form-section">
            <div class="form-container">
                <div class="form-header">
                    <h2>Данные заказа</h2>
                    <p>Заполните все необходимые поля</p>
                </div>

                <?php
                $form = ActiveForm::begin([
                    'id' => 'login-form',
                    'options' => ['class' => 'modern-order-form'],
                    'fieldConfig' => [
                        'template' => "{label}\n{input}\n{error}",
                        'labelOptions' => ['class' => 'form-label'],
                        'inputOptions' => ['class' => 'form-input'],
                        'errorOptions' => ['class' => 'form-error'],
                    ],
                ]) ?>

                <div class="form-row">
                    <div class="input-group">
                        <?= $form->field($model, 'category_id', [
                            'template' => '
                                <div class="input-wrapper">
                                    <div class="input-icon">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                                        </svg>
                                    </div>
                                    {input}
                                    {label}
                                </div>
                                {error}'
                        ])->dropDownList(
                            $categories,
                            [
                                'prompt' => ' ',
                                'class' => 'form-input select-input'
                            ]
                        ) ?>
                    </div>

                    <div class="input-group">
                        <?= $form->field($model, 'product_id', [
                            'template' => '
                                <div class="input-wrapper">
                                    <div class="input-icon">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"/>
                                        </svg>
                                    </div>
                                    {input}
                                    {label}
                                </div>
                                {error}'
                        ])->dropDownList(
                            $products,
                            [
                                'prompt' => ' ',
                                'class' => 'form-input select-input'
                            ]
                        ) ?>
                    </div>
                </div>

                <div class="form-row">
                    <div class="input-group">
                        <?= $form->field($model, 'count_product', [
                            'template' => '
                                <div class="input-wrapper">
                                    <div class="input-icon">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                                        </svg>
                                    </div>
                                    {input}
                                    {label}
                                </div>
                                {error}'
                        ])->textInput(['placeholder' => ' ']) ?>
                    </div>

                    <div class="input-group">
                        <?= $form->field($model, 'date', [
                            'template' => '
                                <div class="input-wrapper">
                                    <div class="input-icon">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                        </svg>
                                    </div>
                                    {input}
                                    {label}
                                </div>
                                {error}'
                        ])->widget(MaskedInput::class, [
                            'mask' => '99.99.9999 99:99',
                            'options' => [
                                'class' => 'form-input',
                                'placeholder' => ' '
                            ]
                        ]) ?>
                    </div>
                </div>

                <div class="input-group">
                    <?= $form->field($model, 'adress', [
                        'template' => '
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                        <path d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    </svg>
                                </div>
                                {input}
                                {label}
                            </div>
                            {error}'
                    ])->textInput(['placeholder' => ' ']) ?>
                </div>

                <div class="input-group">
                    <?= $form->field($model, 'payment_method', [
                        'template' => '
                            <div class="radio-group">
                                <label class="radio-label">Способ оплаты</label>
                                <div class="radio-options">
                                    {input}
                                </div>
                                {error}
                            </div>'
                    ])->radioList([
                        0 => 'Наличными',
                        1 => 'Перевод по телефону'
                    ], [
                        'item' => function($index, $label, $name, $checked, $value) {
                            $id = 'payment_' . $value;
                            return '
                                <label class="radio-option">
                                    <input type="radio" name="' . $name . '" value="' . $value . '" id="' . $id . '" ' . ($checked ? 'checked' : '') . '>
                                    <span class="radio-checkmark"></span>
                                    <span class="radio-text">' . $label . '</span>
                                </label>';
                        }
                    ]) ?>
                </div>

                <div class="input-group">
                    <?= $form->field($model, 'content', [
                        'template' => '
                            <div class="textarea-wrapper">
                                {label}
                                {input}
                                {error}
                            </div>'
                    ])->textarea([
                        'placeholder' => 'Дополнительные пожелания к заказу...',
                        'class' => 'form-textarea',
                        'rows' => 4
                    ]) ?>
                </div>

                <div class="form-actions">
                    <?= Html::submitButton('Оформить заказ', [
                        'class' => 'btn-order-primary',
                        'name' => 'login-button'
                    ]) ?>
                </div>

                <?php ActiveForm::end() ?>
            </div>
        </div>
    </div>
</div>

<style>
    .order-container {
        min-height: 100vh;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 2rem;
    }

    .order-wrapper {
        display: grid;
        grid-template-columns: 1fr 1fr;
        max-width: 1200px;
        width: 100%;
        background: white;
        border-radius: 2rem;
        overflow: hidden;
        box-shadow: 0 25px 50px rgba(0, 0, 0, 0.1);
        min-height: 800px;
    }

    /* Левая часть */
    .order-hero {
        position: relative;
        background: linear-gradient(135deg, #aaeff8ff 0%, #764ba2 100%);
        color: white;
        padding: 3rem;
        display: flex;
        flex-direction: column;
        justify-content: center;
        overflow: hidden;
    }

    .hero-content h1 {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        line-height: 1.2;
    }

    .hero-content p {
        font-size: 1.1rem;
        opacity: 0.9;
        margin-bottom: 2rem;
    }

    .order-features {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .feature-item {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        font-size: 1rem;
    }

    .feature-item svg {
        opacity: 0.8;
    }

    /* Анимированные элементы */
    .floating-elements {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
    }

    .floating-element {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
    }

    .el-1 {
        width: 120px;
        height: 120px;
        top: 10%;
        right: 10%;
        animation: float 8s ease-in-out infinite;
    }

    .el-2 {
        width: 80px;
        height: 80px;
        bottom: 20%;
        left: 15%;
        animation: float 6s ease-in-out infinite 1s;
    }

    .el-3 {
        width: 60px;
        height: 60px;
        top: 50%;
        right: 20%;
        animation: float 7s ease-in-out infinite 0.5s;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0px) rotate(0deg); }
        50% { transform: translateY(-20px) rotate(180deg); }
    }

    /* Правая часть */
    .order-form-section {
        padding: 3rem;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .form-container {
        width: 100%;
        max-width: 500px;
    }

    .form-header {
        text-align: center;
        margin-bottom: 2.5rem;
    }

    .form-header h2 {
        font-size: 2rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }

    .form-header p {
        color: #6b7280;
        font-size: 1rem;
    }

    /* Форма */
    .modern-order-form {
        width: 100%;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }

    .input-group {
        margin-bottom: 1.5rem;
    }

    .input-wrapper {
        position: relative;
    }

    .form-input {
        width: 100%;
        padding: 1rem 1rem 1rem 3rem;
        border: 2px solid #e5e7eb;
        border-radius: 0.75rem;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
    }

    .select-input {
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3e%3c/svg%3e");
        background-position: right 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-right: 2.5rem;
    }

    .form-input:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-label {
        position: absolute;
        left: 3rem;
        top: 1rem;
        color: #9ca3af;
        transition: all 0.3s ease;
        pointer-events: none;
        background: white;
        padding: 0 0.25rem;
    }

    .form-input:focus + .form-label,
    .form-input:not(:placeholder-shown) + .form-label,
    .select-input:valid + .form-label {
        top: -0.5rem;
        left: 0.75rem;
        font-size: 0.875rem;
        color: #667eea;
        font-weight: 500;
    }

    .input-icon {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
        z-index: 2;
    }

    .form-input:focus ~ .input-icon {
        color: #aaeff8ff;
    }

    .form-error {
        color: #ef4444;
        font-size: 0.875rem;
        margin-top: 0.5rem;
        display: block;
    }

    /* Radio Buttons */
    .radio-group {
        width: 100%;
    }

    .radio-label {
        display: block;
        margin-bottom: 1rem;
        font-weight: 500;
        color: #374151;
    }

    .radio-options {
        display: flex;
        gap: 1rem;
        flex-wrap: wrap;
    }

    .radio-option {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        cursor: pointer;
        padding: 1rem 1.5rem;
        border: 2px solid #e5e7eb;
        border-radius: 0.75rem;
        transition: all 0.3s ease;
        flex: 1;
        min-width: 150px;
    }

    .radio-option input {
        display: none;
    }

    .radio-checkmark {
        width: 20px;
        height: 20px;
        border: 2px solid #d1d5db;
        border-radius: 50%;
        position: relative;
        transition: all 0.3s ease;
        flex-shrink: 0;
    }

    .radio-option input:checked + .radio-checkmark {
        border-color: #aaeff8ff;
        background: #aaeff8ff;
    }

    .radio-option input:checked + .radio-checkmark::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 8px;
        height: 8px;
        background: white;
        border-radius: 50%;
    }

    .radio-option input:checked ~ .radio-text {
        color: #aaeff8ff;
        font-weight: 500;
    }

    .radio-option:hover {
        border-color: #aaeff8ff;
        background: #f8fafc;
    }

    .radio-text {
        color: #374151;
        font-weight: 500;
    }

    /* Textarea */
    .textarea-wrapper {
        position: relative;
    }

    .form-textarea {
        width: 100%;
        padding: 1rem;
        border: 2px solid #e5e7eb;
        border-radius: 0.75rem;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
        resize: vertical;
        font-family: inherit;
    }

    .form-textarea:focus {
        outline: none;
        border-color: #aaeff8ff;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .textarea-wrapper .form-label {
        position: absolute;
        left: 1rem;
        top: -0.5rem;
        background: white;
        padding: 0 0.5rem;
        font-size: 0.875rem;
        color: #667eea;
        font-weight: 500;
    }

    /* Кнопка */
    .form-actions {
        margin-top: 2rem;
    }

    .btn-order-primary {
        width: 100%;
        padding: 1.25rem 2rem;
        background: linear-gradient(135deg, #10b981, #059669);
        color: white;
        border: none;
        border-radius: 0.75rem;
        font-size: 1.125rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .btn-order-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(16, 185, 129, 0.3);
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .order-wrapper {
            grid-template-columns: 1fr;
            min-height: auto;
        }

        .order-hero {
            display: none;
        }

        .order-form-section {
            padding: 2rem 1.5rem;
        }

        .form-row {
            grid-template-columns: 1fr;
            gap: 0;
        }

        .form-header h2 {
            font-size: 1.75rem;
        }

        .radio-options {
            flex-direction: column;
        }

        .radio-option {
            min-width: auto;
        }
    }

    @media (max-width: 480px) {
        .order-container {
            padding: 1rem;
        }

        .order-form-section {
            padding: 1.5rem 1rem;
        }
    }
</style>